class Life
  attr_reader :value, :should_die
  def initialize(args, x, y)
    @value = 1

    @position = {x: x, y: y}
    @graphics = [
      {path: "sprites/life.png", w: 32, h: 32, primitive_marker: :sprite}
    ]
    @frame_delay = 10
    @last_frame_time = 0
    @current_frame = 0
    @ttl = 5 * 60 #time to live, in frame count
    @should_die = false
    @is_fading = false
    @alpha = 255
  end

  def tick(args)

    if args.state.tick_count - @last_frame_time > @frame_delay
      @current_frame += 1
      @current_frame = @current_frame % 2
      @last_frame_time = args.state.tick_count
    end

    @alpha = @ttl < 60 && @alpha == 255 ? 128 : 255

    if @ttl <= 0
      @should_die = true
    end

    @ttl -= 1
  end

  def was_player_placed?
    false
  end

  def collision_rect
    {x: @position.x + 8, y: @position.y + 8, w: 16, h: 16}
  end

  def render
    {**@position, source_x: @current_frame * 32, source_y: 0, source_w: 32, source_h: 32, ttl: @ttl, a: @alpha, **@graphics[0]}
  end

  def mark_dead
    @ttl = 0
    @should_die = true
  end

  def inspect
    serialize.to_s
  end

  def serialize
    to_h
  end

  def to_s
    serialize.to_s
  end

  def to_h
    {**@position, should_die: @should_die, ttl: @ttl}
  end
end
